package gov.va.med.mhv.bluebutton.bbdownload.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;


public class PdfXHTMLWrapper {
	private static Log LOG = LogFactory.getLog(PdfXHTMLWrapper.class);

	private static Image img;

	private static final String KEYSTORE_FILENAME="bb.keystoreFileName";
	private static final String KEYSTORE_PWORD="bb.keystorePassword";
	private static final String PRIVATEKEY_PWORD="bb.privateKeyPassword";

	private static final String DIGITAL_SIGN_ENABLE="bb.digitalSign.enable";
	private static final String IS_CERTIFIED="bb.isCertified";
	private static final String IS_VISIBLE="bb.isVisible";

	ClassLoader classLoader;

	public PdfXHTMLWrapper () {
		classLoader = this.getClass().getClassLoader();
	}

	public byte[] makePdfFromXhtmlAPI(String currentUserFullName, String xhtml) throws DocumentException, IOException {
		byte[] result = null;

		String imgRelativePath = "/images/watermark_7_25pct_10pct.jpg";
		URL imgUrl = classLoader.getResource(imgRelativePath);
		img = Image.getInstance(imgUrl);
		
		result = generate(currentUserFullName, xhtml);

		return result;
	}

	public byte[] makePdfFromXhtml( String currentUserFullName, String xhtml) throws DocumentException, IOException {
		byte[] result = null;
		String imgRelativePath = "/images/watermark_7_25pct_10pct.jpg";
		URL imgUrl = classLoader.getResource(imgRelativePath);

		//Make synchronized one time call
		img = Image.getInstance(imgUrl);
		
		result = generate(currentUserFullName, xhtml);

		return result;
	}

	@SuppressWarnings("unchecked")
	private byte[] generate(String name, String xhtml) throws DocumentException, IOException {
		long st = System.currentTimeMillis();

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ByteArrayOutputStream os = new ByteArrayOutputStream();

		ITextRenderer renderer = new ITextRenderer();
		ITextFontResolver r = renderer.getFontResolver();

		try {
			r.addFont("/fonts/CALIBRI.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRII.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRIB.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRIZ.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/TIMESBI.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED

			String escapedXhtml = xhtml.replaceAll("(?i)&(?!(amp|apos|lt|gt|quot|nbsp|#160|#x*[a-fA-F0-9]*);)", "&amp;");
			renderer.setDocumentFromString(escapedXhtml);
			renderer.layout();
			renderer.createPDF(baos, false); // to stream
			renderer.finishPDF();

		} catch (com.lowagie.text.DocumentException e) {
			LOG.error("Exception Occured: " +e);
		}


		// Second pass to setup the page headers
		os.write(addHeaderAndWatermark(name, baos));
		os.flush();
		os.close();

		if(LOG.isInfoEnabled())
			LOG.info("PDF generate took " + (System.currentTimeMillis() - st) + " ms (final size=" + baos.size() + "bytes) for user="+name);
		return os.toByteArray();
	}

	private byte[] addHeaderAndWatermark(String name, ByteArrayOutputStream baos) throws IOException, DocumentException {
		ByteArrayOutputStream baosout = new ByteArrayOutputStream(baos.size());
		PdfReader reader;

		reader = new PdfReader(baos.toByteArray());

		reader.getCatalog().put(PdfName.LANG, new PdfString("EN-US"));
		// Create a stamper
		PdfStamper stamper = new PdfStamper(reader, baosout);
		// Loop over the pages and add a header to each page
		int n = reader.getNumberOfPages();
		for (int i = 1; i <= n; i++) {
			//Add Header
			getHeaderTable(name, i, n).writeSelectedRows(0, -1, 34, 783, stamper.getOverContent(i));

			//Add Watermark
			img.scaleToFit(800, 800);
			img.setAbsolutePosition(0, 0);
			img.setAlt("Medical Confidential");
			stamper.getUnderContent(i).addImage(img);
		}
		// Close the stamper
		stamper.close();

		return baosout.toByteArray();
	}

	public static PdfPTable getHeaderTable(String name, int x, int y) {
		BaseFont bf = null;
		PdfPTable table = new PdfPTable(3);
		try {
			table.setWidths(new int[] { 24, 20, 15 });
			table.setTotalWidth(527);
			table.setLockedWidth(true);
			table.getDefaultCell().setFixedHeight(20);
			table.getDefaultCell().setBorder(Rectangle.NO_BORDER);
			table.getDefaultCell().setHorizontalAlignment(Element.ALIGN_MIDDLE);

			PdfPCell cell0 = new PdfPCell(new Phrase(name, new Font(bf, 10, Font.NORMAL, BaseColor.BLACK)));
			cell0.setVerticalAlignment(Element.ALIGN_BOTTOM);
			cell0.setHorizontalAlignment(Element.ALIGN_LEFT);
			cell0.setBorder(Rectangle.NO_BORDER);
			table.addCell(cell0);

			PdfPCell cell1 = new PdfPCell(new Phrase("CONFIDENTIAL", new Font(bf, 14, Font.BOLD, BaseColor.BLACK)));
			cell1.setBorder(Rectangle.NO_BORDER);
			cell1.setHorizontalAlignment(Element.ALIGN_MIDDLE);
			cell1.setVerticalAlignment(Element.ALIGN_TOP);
			table.addCell(cell1);

			PdfPCell cell2 = new PdfPCell(new Phrase(String.format("Page %d of %d", x, y), new Font(bf, 10, Font.NORMAL, BaseColor.BLACK)));
			cell2.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell2.setVerticalAlignment(Element.ALIGN_BOTTOM);
			cell2.setBorder(Rectangle.NO_BORDER);
			table.addCell(cell2);
		} catch (DocumentException de) {
			throw new ExceptionConverter(de);
		}
		return table;
	}
	
	public static void main(String arv[]) {
		String xhtml = "KJG &#160;";
		String escapedXhtml = xhtml.replaceAll("(?i)&(?!(amp|apos|lt|gt|quot|nbsp|#160);)", "&amp;").replaceAll("&#160;", "&nbsp;");
		System.out.println(escapedXhtml);
	}
}